import {
    IAviaParams,
    IBaggageParams,
    IBaseSearchParams,
    IFlightParams,
    IRefundParams,
    ISeatParams,
    IYtpRefererParams,
} from 'server/services/AviaSearchService/types/IAviaParams';

export const AVIA_BASE_SEARCH_PARAMS_KEYS: (keyof IBaseSearchParams)[] = [
    'fromId',
    'toId',
    'klass',
    'when',
    'return_date',
    'oneway',
];

export const AVIA_SEAT_PARAMS_KEYS: (keyof ISeatParams)[] = [
    'adult_seats',
    'children_seats',
    'infant_seats',
];

export const REQUIRED_AVIA_SEARCH_PARAMS_KEYS: (keyof IAviaParams)[] = [
    'toId',
    'fromId',
    'when',
    'adult_seats',
];

export const AVIA_FLIGHT_PARAMS_KEYS: (keyof IFlightParams)[] = [
    'forward',
    'backward',
];

export const AVIA_FREE_REFUND_PARAM_KEY = 'free_refund';
export const AVIA_CHARGE_REFUND_PARAM_KEY = 'charge_refund';

export const AVIA_REFUND_PARAMS_KEYS: (keyof IRefundParams)[] = [
    AVIA_FREE_REFUND_PARAM_KEY,
    AVIA_CHARGE_REFUND_PARAM_KEY,
];

export const AVIA_BAGGAGE_PARAM_KEY: keyof IBaggageParams = 'baggage';

export const AVIA_YTP_REFERER_PARAMS_KEY: keyof IYtpRefererParams =
    'ytp_referer';

export const AVIA_PARAMS_KEYS: (keyof IAviaParams)[] = [
    ...AVIA_BASE_SEARCH_PARAMS_KEYS,
    ...AVIA_SEAT_PARAMS_KEYS,
    ...AVIA_BASE_SEARCH_PARAMS_KEYS,
    ...AVIA_FLIGHT_PARAMS_KEYS,
    ...AVIA_REFUND_PARAMS_KEYS,
    AVIA_BAGGAGE_PARAM_KEY,
    AVIA_YTP_REFERER_PARAMS_KEY,
    'toName',
    'fromName',
];
