import React from 'react';
import {useSelector} from 'react-redux';

import aviaSearchInformationSelector from 'selectors/avia/aviaSearchInformationSelector';
import {aviaContextSelector} from 'selectors/avia/context/aviaContextSelector';
import {aviaAeroflotPlusSelector} from 'projects/avia/selectors/aviaAeroflotPlusEnabledSelector';
import {hasVariantWithPlusPointsSelector} from 'selectors/avia/search/hasVariantWithPlusPointsSelector';

import {useAviaPortal} from 'utilities/hooks/useAviaPortal';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';
import {isValidDate} from 'utilities/dateUtils';
import {useAviaTotalFilters} from 'projects/avia/lib/hooks/filters/total';

import SearchInformation, {
    ISearchInformationProps,
} from 'components/SearchInformation/SearchInformation';
import {NativeAppBackButton} from 'projects/avia/components/NativeAppBackButton/NativeAppBackButton';
import Flex from 'components/Flex/Flex';
import SearchFiltersTriggerButton from 'projects/avia/components/AviaSearchResultsFilters/components/SearchFiltersTriggerButton/SearchFiltersTriggerButton';

import {usePlatform} from 'contexts/PlatformContext';

import cx from './AviaSearchInformation.scss';

const AviaSearchInformation: React.FC<
    Pick<ISearchInformationProps, 'onClick' | 'className'>
> = props => {
    const aviaAeroflotPlus = useSelector(aviaAeroflotPlusSelector);
    const searchInformation = useSelector(aviaSearchInformationSelector);
    const hasVariantWithPlusPoints = useSelector(
        hasVariantWithPlusPointsSelector,
    );

    const context = useSelector(aviaContextSelector);
    const isRoundtrip = Boolean(
        context.return_date && isValidDate(context.return_date),
    );
    const {isWeb} = usePlatform();
    const deviceType = useDeviceType();
    const isAviaPortal = useAviaPortal();
    const totalFilters = useAviaTotalFilters();

    return (
        <Flex
            className={cx(
                'root',
                {
                    root_aviaPortal: isAviaPortal,
                },
                deviceMods('root', deviceType),
            )}
        >
            {!isWeb && <NativeAppBackButton />}
            <SearchInformation
                deviceType={deviceType}
                {...props}
                {...searchInformation}
            />
            {aviaAeroflotPlus &&
                hasVariantWithPlusPoints &&
                deviceType.isMobile && (
                    <SearchFiltersTriggerButton
                        isRoundtrip={isRoundtrip}
                        className={cx('filtersTriggerButton')}
                        size="xl"
                        totalFilters={totalFilters}
                    />
                )}
        </Flex>
    );
};

export default AviaSearchInformation;
