import {FC} from 'react';
import {useSelector} from 'react-redux';

import {
    EWeatherForecastItemType,
    IWeatherForecastItem,
} from 'types/common/IWeatherForecastItem';
import EAsyncStatus from 'types/common/EAsyncStatus';
import {IGeoRegion} from 'types/hotels/hotel/IGeoRegion';
import {IWithClassName} from 'types/withClassName';

import {getAviaPointsData} from 'selectors/avia/aviaSelectors';

import WeatherForecast from 'components/WeatherForecast/WeatherForecast';

export interface IAviaWeatherForecastProps extends IWithClassName {
    items: IWeatherForecastItem[];
    status: EAsyncStatus | null;
    region?: IGeoRegion;
}

/*
 * жутчайший костыль для подмены иконки среднего прогноза за месяц,
 * это временно, пока это не пофиксили на бэке
 * задачи:
 * https://st.yandex-team.ru/RASPTICKETS-23153 + https://st.yandex-team.ru/TRAVELFRONT-8370
 */
const getNormalizedForecastClimateItem = (
    item: IWeatherForecastItem,
): IWeatherForecastItem => {
    try {
        const newItem = {...item};
        const itemTemperatures =
            item.title
                .split(' ')
                .find(el => /\d/.test(el))
                ?.split('...') || [];
        const itemAverageTemperature =
            itemTemperatures.reduce(
                (acc, el) => Number(el.replace(/\D/g, '')) + acc,
                0,
            ) / itemTemperatures.length;
        const itemDaysWithPrecipitation = Number(
            item.description.replace(/\D/g, ''),
        );

        let imageUrl = item.imageUrl;

        if (itemDaysWithPrecipitation <= 9) {
            imageUrl =
                'https://yastatic.net/weather/i/icons/funky/dark/skc_d.svg';
        } else if (
            itemDaysWithPrecipitation > 9 &&
            itemDaysWithPrecipitation <= 20
        ) {
            imageUrl =
                'https://yastatic.net/weather/i/icons/funky/dark/ovc.svg';
        } else if (
            itemDaysWithPrecipitation > 21 &&
            itemAverageTemperature >= 0
        ) {
            imageUrl =
                'https://yastatic.net/weather/i/icons/funky/dark/ovc_ra.svg';
        } else if (
            itemDaysWithPrecipitation > 21 &&
            itemAverageTemperature < 0
        ) {
            imageUrl =
                'https://yastatic.net/weather/i/icons/funky/dark/ovc_-sn.svg';
        }

        newItem.imageUrl = imageUrl;

        return newItem;
    } catch (e) {
        return item;
    }
};

const AviaWeatherForecast: FC<IAviaWeatherForecastProps> = ({
    items,
    status,
    className,
}) => {
    const pointsData = useSelector(getAviaPointsData);

    const isSkeleton =
        !pointsData.to || status === null || status === EAsyncStatus.LOADING;
    const title = pointsData.to?.settlement?.title || '';

    const normalizedItems = items.map(item => {
        if (item.itemType === EWeatherForecastItemType.FORECAST) {
            return item;
        }

        return getNormalizedForecastClimateItem(item);
    });

    return (
        <WeatherForecast
            className={className}
            items={normalizedItems}
            isSkeleton={isSkeleton}
            cityTitle={title}
        />
    );
};

export default AviaWeatherForecast;
