import React, {useCallback} from 'react';
import {useSelector} from 'react-redux';

import {EYtpReferer} from 'types/common/IAttribution';
import {EAviaGoal} from 'utilities/metrika/types/goals/avia';

import {aviaContextForCrossSaleSelector} from 'selectors/avia/search/aviaContextForCrossSaleSelector';

import {reachGoal} from 'utilities/metrika';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import SearchHotelsCrossSaleMap from 'components/SearchHotelsCrossSaleMap/SearchHotelsCrossSaleMap';

import cx from './CrossSaleMap.scss';

interface ICrossSaleMapProps extends IWithQaAttributes {}

const CrossSaleMap: React.FC<ICrossSaleMapProps> = props => {
    const requestParams = useSelector(aviaContextForCrossSaleSelector);

    const onCrossSaleShow = useCallback(() => {
        reachGoal(EAviaGoal.CROSS_SALE_HOTELS_MAP_LOAD);
    }, []);

    const onCrossSaleClick = useCallback(() => {
        reachGoal(EAviaGoal.CROSS_SALE_HOTELS_MAP_CLICK);
    }, []);

    if (!requestParams) {
        return null;
    }

    return (
        <SearchHotelsCrossSaleMap
            className={cx('root')}
            requestParams={requestParams}
            ytpReferer={EYtpReferer.AVIA_SEARCH_MAP}
            onCrossSaleShow={onCrossSaleShow}
            onCrossSaleClick={onCrossSaleClick}
            {...prepareQaAttributes(props)}
        />
    );
};

export default React.memo(CrossSaleMap);
