/* eslint-disable camelcase */
import {connect} from 'react-redux';
import {get} from 'lodash';
import {stringify as qsStringify} from 'query-string';

import {PRODUCTION_PROJECT_URL} from 'constants/common';

import {IAviaPointSettlementData} from 'server/services/AviaGeoService/types/IAviaDataByPointKey';

import {IAviaContext, IAviaPointsData} from 'reducers/avia/data-types';

import {getAviaContext, getAviaPointsData} from 'selectors/avia/aviaSelectors';

import {humanFormatDate} from 'utilities/dateUtils';

import * as i18nBlockAviaMetaSearch from 'i18n/avia-metaSearch';

import DocumentMeta from 'components/DocumentMeta/DocumentMeta';
import SocialSharingMeta from 'components/SocialSharingMeta/SocialSharingMeta';

interface IAviaSearchMetaProps {
    aviaPointsData: IAviaPointsData;
    aviaContext: IAviaContext;
}

function _AviaSearchMeta(props: IAviaSearchMetaProps) {
    const {aviaPointsData, aviaContext} = props;
    const fromSettlement = get(
        aviaPointsData,
        'from.settlement',
    ) as IAviaPointSettlementData | null;
    const toSettlement = get(
        aviaPointsData,
        'to.settlement',
    ) as IAviaPointSettlementData | null;
    const {when, return_date, fromName, toName} = aviaContext;

    if (!when) {
        return null;
    }

    const humanWhen = humanFormatDate(when);
    const humanReturnDate = return_date && humanFormatDate(return_date);

    const textFunctions = return_date
        ? {
              ogDescription:
                  i18nBlockAviaMetaSearch.ogDashDescriptionDashRoundtrip,
              ogTitle: i18nBlockAviaMetaSearch.ogDashTitleDashRoundtrip,
              title: i18nBlockAviaMetaSearch.titleDashRoundtrip,
          }
        : {
              ogDescription:
                  i18nBlockAviaMetaSearch.ogDashDescriptionDashOneway,
              ogTitle: i18nBlockAviaMetaSearch.ogDashTitleDashOneway,
              title: i18nBlockAviaMetaSearch.titleDashOneway,
          };

    const metaInfo = {
        ogDescription: textFunctions.ogDescription({
            phraseFromTitle: fromSettlement?.phraseFrom ?? '',
            phraseToTitle: toSettlement?.phraseTo ?? '',
        }),
        ogTitle: textFunctions.ogTitle({
            fromTitle: fromName,
            toTitle: toName,
            when: humanWhen,
            returnDate: humanReturnDate,
        }),
        title: textFunctions.title({
            phraseFromTitle: fromSettlement?.phraseFrom ?? '',
            toTitle: toName,
            when: humanWhen,
            returnDate: humanReturnDate,
        }),
    };

    const searchQuery = qsStringify({when, return_date, fromName, toName});
    const ogUrl = `${PRODUCTION_PROJECT_URL}/avia/search/result?${searchQuery}`;

    return (
        <>
            <DocumentMeta title={metaInfo.title} />
            <SocialSharingMeta
                url={ogUrl}
                title={metaInfo.ogTitle}
                description={metaInfo.ogDescription}
            />
        </>
    );
}

const mapStateToProps = (state: any) => ({
    aviaPointsData: getAviaPointsData(state),
    aviaContext: getAviaContext(state),
});

export const AviaSearchMeta =
    connect<IAviaSearchMetaProps>(mapStateToProps)(_AviaSearchMeta);
