import React, {createContext, useContext} from 'react';
import {noop} from 'lodash';

import {TAviaBaseFilterAction} from 'reducers/avia/search/results/filters/actions';

import {useAviaFiltersBuffer} from 'projects/avia/lib/hooks/useFiltersBuffer';

interface IAviaFiltersBufferContext {
    put: (action: TAviaBaseFilterAction) => void;
    flush: () => void;
}

export const AviaFiltersBufferContext =
    createContext<IAviaFiltersBufferContext>({
        put: noop,
        flush: noop,
    });

export function useAviaFiltersBufferContext(): IAviaFiltersBufferContext {
    const context = useContext(AviaFiltersBufferContext);

    if (!context) {
        throw new Error(
            'Component should be wrapped by AviaFiltersBufferProvider',
        );
    }

    return context;
}

export const AviaFiltersBufferProvider: React.FC = ({children}) => {
    const filtersBuffer = useAviaFiltersBuffer();

    return (
        <AviaFiltersBufferContext.Provider value={filtersBuffer}>
            {children}
        </AviaFiltersBufferContext.Provider>
    );
};
