import {useCallback, useMemo} from 'react';
import {useSelector} from 'react-redux';
import {useLocation} from 'react-router-dom';

import {qidSelector} from 'selectors/avia/aviaSelectors';
import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

import {getYtpRefererFromQuery} from 'utilities/ytpReferer';
import {useAviaTestContext} from '../lib/hooks/useAviaTestContext';
import {aviaURLs} from '../lib/urls';

/**
 * Функция для получения url на страницу редиректа варианта
 * Использовать только если не подходит RedirectLink
 */
export const useGetRedirectUrl = (): ((
    variant: IResultAviaVariant,
) => string) => {
    const location = useLocation();

    const testContext = useAviaTestContext();
    const ytpReferer = useMemo(
        () => getYtpRefererFromQuery(location.search),
        [location.search],
    );
    const qid = useSelector(qidSelector);

    const getRedirectUrl = useCallback(
        (variant: IResultAviaVariant): string => {
            const {boy} = variant.price;

            return qid
                ? aviaURLs.createUrlToRedirectPage({
                      ...variant,
                      ...testContext,
                      ytpReferer,
                      qid,
                      boy,
                  })
                : '';
        },
        [qid, testContext, ytpReferer],
    );

    return getRedirectUrl;
};
