import {useCallback} from 'react';

import {EAppActions} from 'constants/platforms/TPlatforms';

import {EAviaGoal} from 'utilities/metrika/types/goals/avia';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

import {reachGoal} from 'utilities/metrika';

import {useCoordinator, INotifierBuyTickets} from 'contexts/PlatformContext';

import {useGetRedirectUrl} from './useGetRedirectUrl';

/**
 * Функция для получения обработчика события для перехода на страницу редиректа
 * Использовать только если не подходит RedirectLink
 */
export const useOnBuyHandler = (): ((offer: IResultAviaVariant) => void) => {
    const coordinator = useCoordinator();
    const getRedirectUrl = useGetRedirectUrl();

    const onBuyHandler = useCallback(
        (offer: IResultAviaVariant) => {
            reachGoal(EAviaGoal.SEARCH_REDIRECT);

            const redirectUrl = getRedirectUrl(offer);

            if (coordinator.canProcess(EAppActions.BUY_TICKETS)) {
                coordinator.doAction<INotifierBuyTickets>(
                    EAppActions.BUY_TICKETS,
                    {
                        offer,
                        redirectUrl,
                    },
                );
            } else {
                window.open(redirectUrl, '_blank');
            }
        },
        [getRedirectUrl, coordinator],
    );

    return onBuyHandler;
};
