import {useMemo} from 'react';

import IPrice from 'utilities/currency/PriceInterface';
import {useCurrencyConverter} from 'utilities/hooks/useCurrencyConverter';

/** Вернёт разницу между ценами в предпочтительной валюте пользователя */
export function usePriceDiff(
    priceA?: IPrice,
    priceB?: IPrice,
): Nullable<{
    price: IPrice;
    isRoughly: boolean;
}> {
    const currencyConverter = useCurrencyConverter();

    const result = useMemo(() => {
        if (!priceA || !priceB) {
            return null;
        }

        return {
            price: {
                value:
                    currencyConverter.convertToPreferredCurrency(priceA).value -
                    currencyConverter.convertToPreferredCurrency(priceB).value,
                currency: currencyConverter.getPreferredCurrency(),
            },
            isRoughly: !currencyConverter.areSameCurrencies(
                priceA.currency,
                priceB.currency,
            ),
        };
    }, [currencyConverter, priceA, priceB]);

    return result;
}
