import {IAviaOrderFlight} from 'types/avia/book/IAviaOrderFlight';

import {parseDate} from 'utilities/dateUtils';

export const getTransferDurationInMinutes = (
    arrivalFlight: IAviaOrderFlight,
    departureFlight: IAviaOrderFlight,
): number => {
    const departureDateTime = parseDate(departureFlight.departureDate);
    const arrivalDateTime = parseDate(arrivalFlight.arrivalDate);

    return departureDateTime.diff(arrivalDateTime, 'minutes');
};
