import {ECompareResult, TComparator, ESortDirection} from './TComparator';

type Comparable = string | number;

export function compareBy<T, Result extends Comparable>(
    fn: (x: T) => Result,
): TComparator<T> {
    return (x, y, direction = ESortDirection.ASCENDING): ECompareResult => {
        const a = fn(x);
        const b = fn(y);
        const sign = direction === ESortDirection.DESCENDING ? -1 : 1;
        if (a > b) {
            return sign * ECompareResult.GT;
        }
        if (a < b) {
            return sign * ECompareResult.LT;
        }
        return ECompareResult.EQ;
    };
}
