import {ECompareResult} from './TComparator';
import {compareWith} from './compareWith';

// Наивная проверка на наличие в строке кириллических букв
function isCyrillic(str: string) {
    return /[а-яА-ЯёЁ]+/.test(str);
}

/**
 * Сортировка строк по языку и алфавиту названия.
 * Первыми идут названия кириллицей, следом латиницей
 */
export const compareStrings = compareWith((a: string, b: string) => {
    const aIsCyrillic = isCyrillic(a);
    const bIsCyrillic = isCyrillic(b);

    const isSameLang = aIsCyrillic === bIsCyrillic;

    // Если названия на одном языке, то принимаем решение сравнивая строки
    if (isSameLang) {
        return a < b ? ECompareResult.LT : ECompareResult.GT;
    }

    // Если названия на разных языках, то ставим вперед кириллическое название
    return aIsCyrillic ? ECompareResult.LT : ECompareResult.GT;
});
