import {ECompareResult, TComparator, ESortDirection} from './TComparator';

export function compareWith<T>(
    fn: (x: T, y: T) => ECompareResult,
): TComparator<T> {
    return (x, y, direction = ESortDirection.ASCENDING): ECompareResult => {
        return direction === ESortDirection.DESCENDING
            ? fn(x, y) * -1
            : fn(x, y);
    };
}
