import moment from 'moment';

export function getDuration(
    duration: number,
    withoutMinutesIfSomeDays: boolean = false,
): {
    days: number;
    hours: number;
    minutes: number;
} {
    const momentDuration = moment.duration(duration);

    const days = momentDuration.days();

    return {
        days,
        hours: momentDuration.hours(),
        minutes:
            withoutMinutesIfSomeDays && days > 0 ? 0 : momentDuration.minutes(),
    };
}
