import moment from 'moment';

import {isValidDate} from 'projects/avia/lib/date/isValidDate';
import {ROBOT} from 'utilities/dateUtils/formats';

export function isValidActualDate(date?: string): boolean {
    return isValidDate(date)
        ? moment().isSameOrBefore(moment(date, ROBOT), 'day')
        : false;
}
