import moment from 'moment';

import {ROBOT} from 'utilities/dateUtils/formats';

// с префиксом, т.к. содержит специфичную для авиа логику
export function parseAviaDate(date?: string): string | undefined {
    if (!date) {
        return undefined;
    }

    const momentDate = moment(date);

    return momentDate && momentDate.isValid()
        ? momentDate.format(ROBOT)
        : undefined;
}
