import _ from 'lodash';

import {TLD} from 'constants/tld';

import {Platform} from 'types/Platform';

const optionsToCodes = {
    [TLD.RU]: {
        desktop: {
            serp: 'R-I-127716-40',
            buy: 'R-I-127716-15',
            buyExperiment: 'R-I-127716-34',
            right: 'R-I-127716-6',
            second: 'R-I-127716-24',

            russiaToForeign: 'R-I-127716-26',
            russiaToForeignStub: 'R-I-127716-35',

            foreignToRussia: 'R-I-127716-33',
            foreignToRussiaStub: 'R-I-127716-37',

            russiaToRussia: 'R-I-127716-32',
            russiaToRussiaStub: 'R-I-127716-36',

            companiesRewiwsList: 'R-I-127716-29',
            flightsRewiewsList: 'R-I-127716-30',
            orderRewiewsList: 'R-I-127716-31',
            flight: 'R-I-272158-23',
            flights: 'R-I-127716-28',
            company: 'R-I-127716-27',
        },
        touch: {
            serp: 'R-I-242961-1',
            buy: 'R-I-242961-2',

            russiaToForeign: 'R-I-267702-2',
            russiaToForeignStub: 'R-I-267702-5',

            foreignToRussia: 'R-I-267702-4',
            foreignToRussiaStub: 'R-I-267702-7',

            russiaToRussia: 'R-I-267702-3',
            russiaToRussiaStub: 'R-I-267702-6',
        },
    },
    [TLD.UA]: {
        desktop: {
            serp: 'R-I-127716-40',
            buy: 'R-I-127716-15',
            buyExperiment: 'R-I-127716-34',
            right: 'R-I-127716-6',
            second: 'R-I-127716-24',
        },
        touch: {
            serp: 'R-I-242961-1',
            buy: 'R-I-242961-2',
        },
    },
    [TLD.COM_TR]: {
        desktop: {
            serp: 'R-I-265112-5',
            buy: 'R-I-265112-2',
            buyExperiment: 'R-I-127716-34',
            right: 'R-I-265112-1',
            second: 'R-I-265112-3',
        },
        touch: {
            serp: 'R-I-265485-1',
            buy: '',
        },
    },
    [TLD.KZ]: {
        desktop: {
            serp: 'R-I-127716-40',
            buy: 'R-I-127716-15',
            buyExperiment: 'R-I-127716-34',
            right: 'R-I-127716-6',
            second: 'R-I-127716-24',
        },
        touch: {
            serp: 'R-I-242961-1',
            buy: 'R-I-242961-2',
        },
    },
};

export const directHelper = {
    getId: (tld: TLD, platform: Platform, name: string) => {
        return _.get(optionsToCodes, `${tld}.${platform}.${name}`, null);
    },
};
