import EAsyncStatus from 'types/common/EAsyncStatus';

interface IGetActualStatus {
    isActual: boolean;
    status: EAsyncStatus | null;
}

/**
 * Возвращает статус запроса за данными динамики для актуальных параметров динамики
 * @param isActual - признак актуальности данных о ценах для новых параметров запроса динамики
 * @param status - статус запроса за данными динамики
 */
export default function getActualStatus({
    isActual,
    status,
}: IGetActualStatus): EAsyncStatus {
    if (!isActual || !status) {
        return EAsyncStatus.LOADING;
    }

    return status;
}
