import moment from 'moment';

import {IAviaParams} from 'server/services/AviaSearchService/types/IAviaParams';

/**
 * Вычисляет разницу в днях между вылетом туда и обратно
 */
export default function getDatesDelta(searchForm: IAviaParams): number | null {
    if (!searchForm.return_date) {
        return null;
    }

    const dateForward = moment.utc(searchForm.when);
    const dateBackward = moment.utc(searchForm.return_date);

    return dateBackward.diff(dateForward, 'days');
}
