import TValidDataForRequestDynamic from 'types/avia/dynamic/TValidDataForRequestDynamic';
import {IDataForRequestDynamic} from 'types/avia/dynamic/IDataForRequestDynamic';
import EAsyncStatus from 'types/common/EAsyncStatus';

import {TDynamicsDaysInfo} from 'reducers/avia/aviaPriceIndex/utils/convertPriceIndexDataToDynamicsData';

import isValidDataForRequestDynamic from 'projects/avia/lib/dynamic/isValidDataForRequestDynamic';
import needRequest from 'projects/avia/lib/dynamic/needRequest';
import getActualStatus from 'projects/avia/lib/dynamic/getActualStatus';
import isCompatibleDynamicSearch from 'projects/avia/lib/dynamic/isCompatibleDynamicSearch';

export interface IGetDynamicInfo {
    requestParams: IDataForRequestDynamic | null;
    currentRequestParams: TValidDataForRequestDynamic | null;
    status: EAsyncStatus | null;
    prices: TDynamicsDaysInfo | null;
}

export interface IGetDynamicInfoResult {
    isValidRequestParams: boolean;
    isActual: boolean;
    needRequest: boolean;
    actualStatus: EAsyncStatus;

    requestParams?: TValidDataForRequestDynamic;
    prices?: TDynamicsDaysInfo;
}

/**
 * Возвращает основную информацию по динамике для компонентов
 */
export default function getDynamicInfo({
    requestParams,
    currentRequestParams,
    status,
    prices,
}: IGetDynamicInfo): IGetDynamicInfoResult {
    let isValidRequestParams: boolean;
    let isActual: boolean;

    if (!requestParams || !isValidDataForRequestDynamic(requestParams)) {
        isValidRequestParams = false;
        isActual = false;

        return {
            isValidRequestParams,
            isActual,
            needRequest: needRequest({
                isActual,
                isValidRequestParams,
            }),
            actualStatus: getActualStatus({
                isActual,
                status,
            }),
        };
    }

    isValidRequestParams = true;

    isActual = !(
        !currentRequestParams ||
        !isCompatibleDynamicSearch(requestParams, currentRequestParams)
    );

    return {
        isValidRequestParams,
        isActual,
        requestParams,
        prices: isActual && prices ? prices : undefined,
        needRequest: needRequest({
            isActual,
            isValidRequestParams,
        }),
        actualStatus: getActualStatus({
            isActual,
            status,
        }),
    };
}
