export type TNearestIndexes = {
    start: number;
    end: number;
};

/**
 * Возвращает индексы ближайших элементов от конкретного элемента в массиве
 * по следующей логике: берется +-n элементов от переданного, но если слева
 * или справа элементов не хватает, то в выборку включаются элементы с
 * противоположной стороны.
 *
 * @param arr - массив с элементами
 * @param indexOfElement - индекс элемента, относительно которого нужно найти ближайшие
 * @param leftRange - количество ближайших элементов слева от indexOfElement
 * @param rightRange - количество ближайших элементов справа от indexOfElement - по-умолчанию равно leftRange
 */
export default function getNearestIndexes(
    arr: unknown[],
    indexOfElement: number,
    leftRange: number,
    rightRange = leftRange,
): TNearestIndexes {
    let start = indexOfElement - leftRange;
    let end = indexOfElement + rightRange;
    const maxIndex = arr.length - 1;

    if (start < 0) {
        end += Math.abs(start);
        start = 0;
    }

    if (end > maxIndex) {
        start -= end - maxIndex;

        if (start < 0) {
            start = 0;
        }

        end = maxIndex;
    }

    return {
        start,
        end,
    };
}
