import EAsyncStatus from 'types/common/EAsyncStatus';
import IDataForRequestTableDynamic from 'types/avia/dynamic/IDataForRequestTableDynamic';
import TValidDataForRequestTableDynamic from 'types/avia/dynamic/TValidDataForRequestTableDynamic';

import {TDynamicTableDaysInfo} from 'reducers/avia/aviaPriceIndex/utils/convertPriceIndexDataToDynamicsData';

import needRequest from 'projects/avia/lib/dynamic/needRequest';
import getActualStatus from 'projects/avia/lib/dynamic/getActualStatus';
import isValidDataForRequestTableDynamic from 'projects/avia/lib/dynamic/isValidDataForRequestTableDynamic';
import isCompatibleTableDynamicSearch from 'projects/avia/lib/dynamic/isCompatibleTableDynamicSearch';

export interface IGetTableDynamicInfo {
    requestParams: IDataForRequestTableDynamic | null;
    currentRequestParams: TValidDataForRequestTableDynamic | null;
    status: EAsyncStatus | null;
    prices: TDynamicTableDaysInfo | null;
}

export interface IGetTableDynamicInfoResult {
    isValidRequestParams: boolean;
    isActual: boolean;
    needRequest: boolean;
    actualStatus: EAsyncStatus;

    requestParams?: TValidDataForRequestTableDynamic;
    prices?: TDynamicTableDaysInfo;
}

/**
 * Возвращает основную информацию по табличному представлению динамики для компонентов
 */
export default function getTableDynamicInfo({
    requestParams,
    currentRequestParams,
    status,
    prices,
}: IGetTableDynamicInfo): IGetTableDynamicInfoResult {
    let isValidRequestParams: boolean;
    let isActual: boolean;

    if (!requestParams || !isValidDataForRequestTableDynamic(requestParams)) {
        isValidRequestParams = false;
        isActual = false;

        return {
            isValidRequestParams,
            isActual,
            needRequest: needRequest({
                isActual,
                isValidRequestParams,
            }),
            actualStatus: getActualStatus({
                isActual,
                status,
            }),
        };
    }

    isValidRequestParams = true;

    isActual = !(
        !currentRequestParams ||
        !isCompatibleTableDynamicSearch(requestParams, currentRequestParams)
    );

    return {
        isValidRequestParams,
        isActual,
        requestParams,
        prices: isActual && prices ? prices : undefined,
        needRequest: needRequest({
            isActual,
            isValidRequestParams,
        }),
        actualStatus: getActualStatus({
            isActual,
            status,
        }),
    };
}
