import {IDataForRequestDynamic} from 'types/avia/dynamic/IDataForRequestDynamic';

import isSameSearchFilters from 'projects/avia/lib/dynamic/isSameSearchFilters';
import isCompatibleSearchForm from 'projects/avia/lib/dynamic/isCompatibleSearchForm';

/**
 * Проверяет что данные для запроса "a" к динамике цен, применимы к запросу "b".
 * То есть цены из запроса "a" можно добавить к ценами от запроса "b".
 * Или можно взять цены из запроса "b" и использовать их, не производя запрос "a".
 *
 * Для этого фильтры должны быть идентичными, а сами формы поиска могут отличаться
 * только днями прибытия/отправления, но не разницей в днях между
 * вылетом и прилетом.
 *
 * Таким образом можно понимать, что данные weekPrices (блок на странице
 * поиска) и dynamicPrices (календарь с ценами) совместимы.
 */
export default function isCompatibleDynamicSearch(
    a: IDataForRequestDynamic,
    b: IDataForRequestDynamic,
): boolean {
    return (
        isCompatibleSearchForm(a.searchForm, b.searchForm) &&
        isSameSearchFilters(a.filters, b.filters) &&
        a.interval.startDate >= b.interval.startDate &&
        a.interval.endDate <= b.interval.endDate
    );
}
