import {AVIA_PARAMS_KEYS} from 'projects/avia/constants/queryParams';

import TValidDataForRequestTableDynamic from 'types/avia/dynamic/TValidDataForRequestTableDynamic';
import TValidDataForRequestDynamic from 'types/avia/dynamic/TValidDataForRequestDynamic';

import isSameSearchFilters from 'projects/avia/lib/dynamic/isSameSearchFilters';

const PARAMS_FOR_COMPARE = AVIA_PARAMS_KEYS.filter(
    value => value !== 'when' && value !== 'return_date',
);

/**
 * Проверяет, что данные запроса динамики цен можно добавить к табличному представлению динамики
 */
export default function isCompatibleDynamicSearchWithTableDynamic(
    searchRequestParams: TValidDataForRequestDynamic,
    currentTableRequestParams: TValidDataForRequestTableDynamic,
): boolean {
    return (
        PARAMS_FOR_COMPARE.every(
            key =>
                searchRequestParams.searchForm[key] ===
                currentTableRequestParams.searchForm[key],
        ) &&
        isSameSearchFilters(
            searchRequestParams.filters,
            currentTableRequestParams.filters,
        )
    );
}
