import {AVIA_PARAMS_KEYS} from 'projects/avia/constants/queryParams';

import {IAviaParams} from 'server/services/AviaSearchService/types/IAviaParams';

import getDatesDelta from 'projects/avia/lib/dynamic/getDatesDelta';

const PARAMS_FOR_COMPARE = AVIA_PARAMS_KEYS.filter(
    value => value !== 'when' && value !== 'return_date',
);

/**
 * Проверяет, что две поисковые формы для запроса динамики совместимы:
 * совпадают все свойства поисковой формы, кроме дней вылета - для них главное,
 * чтобы совпала разница в днях между вылетом туда и обратно
 */
export default function isCompatibleSearchForm(
    a: IAviaParams,
    b: IAviaParams,
): boolean {
    if (a === b) {
        return true;
    }

    return (
        getDatesDelta(a) === getDatesDelta(b) &&
        PARAMS_FOR_COMPARE.every(key => a[key] === b[key])
    );
}
