import {AVIA_PARAMS_KEYS} from 'projects/avia/constants/queryParams';

import {IAviaParams} from 'server/services/AviaSearchService/types/IAviaParams';

/**
 * Проверяет, что две поисковые формы для запроса динамики табличного
 * представления динамики совместимы
 */
export default function isCompatibleSearchFormForTableDynamic(
    a: IAviaParams,
    b: IAviaParams,
): boolean {
    if (a === b) {
        return true;
    }

    return AVIA_PARAMS_KEYS.every(key => a[key] === b[key]);
}
