import TValidDataForRequestTableDynamic from 'types/avia/dynamic/TValidDataForRequestTableDynamic';

import isCompatibleSearchFormForTableDynamic from 'projects/avia/lib/dynamic/isCompatibleSearchFormForTableDynamic';
import isSameSearchFilters from 'projects/avia/lib/dynamic/isSameSearchFilters';

/**
 * Проверяет, что данные для запроса табличного представления динамики совместимы.
 * То есть цены из запроса "a" можно использовать не производя запрос "b" и наоборот.
 */
export default function isCompatibleTableDynamicSearch(
    a: TValidDataForRequestTableDynamic,
    b: TValidDataForRequestTableDynamic,
): boolean {
    return (
        isCompatibleSearchFormForTableDynamic(a.searchForm, b.searchForm) &&
        isSameSearchFilters(a.filters, b.filters)
    );
}
