import {IDataForRequestDynamic} from 'types/avia/dynamic/IDataForRequestDynamic';
import TValidDataForRequestDynamic from 'types/avia/dynamic/TValidDataForRequestDynamic';

import isValidSearchForm from 'projects/avia/lib/dynamic/isValidSearchForm';

/**
 * Проверяет, что данные для запроса динамики валидны
 */
export default function isValidDataForRequestDynamic(
    data: IDataForRequestDynamic,
): data is TValidDataForRequestDynamic {
    const {
        searchForm,
        interval: {startDate, endDate},
    } = data;
    const {when, return_date: returnDate} = searchForm;

    return (
        isValidSearchForm(searchForm) &&
        startDate <= endDate &&
        (!returnDate || when <= returnDate)
    );
}
