import {IAviaParams} from 'server/services/AviaSearchService/types/IAviaParams';
import TValidRoundTripSearchForm from 'types/avia/dynamic/TValidRoundTripSearchForm';

import isValidSearchForm from 'projects/avia/lib/dynamic/isValidSearchForm';
import isDateRobot from 'utilities/dateUtils/isDateRobot';

export default function isValidRoundTripSearchForm(
    searchForm: IAviaParams,
): searchForm is TValidRoundTripSearchForm {
    return isValidSearchForm(searchForm) && isDateRobot(searchForm.return_date);
}
