import {IAviaParams} from 'server/services/AviaSearchService/types/IAviaParams';
import TValidSearchForm from 'types/avia/dynamic/TValidSearchForm';

import isDateRobot from 'utilities/dateUtils/isDateRobot';

export default function isValidSearchForm(
    searchForm: IAviaParams,
): searchForm is TValidSearchForm {
    const {when, fromId, toId} = searchForm;

    if (!isDateRobot(when)) {
        return false;
    }

    if (!fromId || !toId) {
        return false;
    }

    return true;
}
