interface INeedRequest {
    isActual: boolean;
    isValidRequestParams: boolean;
}

/**
 * Возвращает признак необходимости выполнения запроса за новыми данными динамики
 * @param isActual - признак актуальности данных о ценах для новых параметров запроса динамики
 * @param isValidRequestParams - признак валидности данных для нового запроса
 */
export default function needRequest({
    isActual,
    isValidRequestParams,
}: INeedRequest): boolean {
    return !isActual && isValidRequestParams;
}
