import {ReactNode} from 'react';

import {TermAvailability} from 'server/api/AviaBookingApi/types/TermAvailability';

import {CHAR_MULTIPLICATION_SIGN} from 'utilities/strings/charCodes';

import * as keyset from 'i18n/avia-flightFareTerms-formatters';

import BaggageFormatterVerbose from 'projects/avia/components/BaggageFormatterVerbose/BaggageFormatterVerbose';

export function formatTermAvailability(availability: TermAvailability): string {
    switch (availability) {
        case TermAvailability.FREE:
            return keyset.free();
        case TermAvailability.CHARGE:
            return keyset.charge();
        case TermAvailability.NOT_AVAILABLE:
            return keyset.notDashAvailable();
    }
}

interface IBaggageParams {
    places?: number;
    weight?: number;
    size?: string;
}

export function formatCarryOn({
    places,
    weight,
    size,
}: IBaggageParams): ReactNode {
    if (places) {
        return (
            <BaggageFormatterVerbose
                places={places}
                weight={weight}
                size={size}
            />
        );
    }

    return keyset.noDashBaggage();
}

export function formatBaggage({
    places,
    weight,
}: IBaggageParams): JSX.Element | string {
    if (places) {
        return <BaggageFormatterVerbose places={places} weight={weight} />;
    }

    return keyset.noDashBaggage();
}

export function formatBaggageCompact({places, weight}: IBaggageParams): string {
    if (places) {
        return keyset.baggageDashCompact({places, weight: weight ?? false});
    }

    return keyset.noDashBaggageDashCompact();
}

export function formatTermType(type: string): string {
    switch (type) {
        case 'refundable':
            return keyset.refundable();
        case 'changingCarriage':
            return keyset.changingCarriage();
        case 'carryOn':
            return keyset.carryOn();
        case 'baggage':
            return keyset.baggage();
        case 'miles':
            return keyset.miles();
        case 'seatPreselection':
            return keyset.seatPreselection();
        case 'plusPoints':
            return keyset.plusPoints();
        default:
            return type;
    }
}

export function formatSize(size?: string): string {
    if (!size) {
        return '';
    }

    // фиксим символ разделитель размеров багажа и ручной клади (в случае когда размер приходит с бэка)
    const formatedSize = size.replaceAll('x', CHAR_MULTIPLICATION_SIGN);

    return keyset.size({
        size: formatedSize,
    });
}
