import {ANYWHERE_POINT_KEY} from 'projects/avia/constants/constants';

import {EAviaSuggestsApiItemType} from 'server/api/AviaSuggestsApi/types/TAviaGetSuggestsApiResponse';

import {IPreparedAviaSuggestItemWithIsUniqueTitle} from 'server/services/AviaService/utilities/prepareSuggestsResponse';

import * as i18nSearchToAnywhere from 'i18n/avia-SearchToAnywhere';

/** Возвращает элемент саджеста для поиска куда угодно */
export function getSuggestForAnywhere(): IPreparedAviaSuggestItemWithIsUniqueTitle {
    return {
        isUniqueTitle: true,
        type: EAviaSuggestsApiItemType.SPECIAL,
        title: i18nSearchToAnywhere.suggestTitle(),
        pointCode: '',
        pointKey: ANYWHERE_POINT_KEY,
        countryTitle: '',
        cityTitle: '',
        regionTitle: '',
        specialDescription: i18nSearchToAnywhere.suggestDescription(),
        groupName: i18nSearchToAnywhere.suggestGroupName(),
    };
}
