import {useCallback} from 'react';
import {createSelector} from 'reselect';

import {
    resetFilterValue,
    setBaggageFilter,
} from 'reducers/avia/search/results/filters/actions';

import {aviaBaggageFilterSelector} from 'selectors/avia/search/filters/baggageFilter';
import {aviaFiltersViewDataSelector} from 'selectors/avia/search/filters/viewData';

import {useAsyncAction} from 'utilities/hooks/useAsyncAction';
import {useAviaFilteringFlow} from 'projects/avia/lib/hooks/useFilteringFlow';

const filterSelector = createSelector(
    aviaBaggageFilterSelector.value,
    aviaFiltersViewDataSelector.baggage,
    aviaBaggageFilterSelector.isActive,
    (value, viewData, isActive) => ({
        value,
        viewData,
        isActive,
    }),
);

export interface IUseAviaBaggageFilter {
    filter: ReturnType<typeof filterSelector>;
    handle: () => void;
    reset: () => void;
}

export const useAviaBaggageFilter = (): IUseAviaBaggageFilter => {
    const filtering = useAviaFilteringFlow();
    const [filter, handleAsync] = useAsyncAction(
        filterSelector,
        filtering.end,
        200,
    );
    const handle = useCallback(() => {
        const enabled = !filter.value.enabled;

        filtering.start(setBaggageFilter(enabled));
        handleAsync(setBaggageFilter, enabled);
    }, [filter.value.enabled, handleAsync, filtering]);
    const reset = useCallback(() => {
        filtering.start(resetFilterValue('baggage'));
        handleAsync(resetFilterValue, 'baggage');
    }, [handleAsync, filtering]);

    return {filter, handle, reset};
};
