import {createSelector} from 'reselect';
import {useCallback} from 'react';

import {
    resetFilterValue,
    setCompanyFilter,
} from 'reducers/avia/search/results/filters/actions';
import {IAviaSearchResultsFilters} from 'reducers/avia/search/results/filters/reducer';

import {aviaFiltersViewDataSelector} from 'selectors/avia/search/filters/viewData';
import {aviaCompanyFilterSelector} from 'selectors/avia/search/filters/companyFilter';

import {useAsyncAction} from 'utilities/hooks/useAsyncAction';
import {useAviaFilteringFlow} from 'projects/avia/lib/hooks/useFilteringFlow';

const filterSelector = createSelector(
    aviaCompanyFilterSelector.value,
    aviaFiltersViewDataSelector.company,
    aviaCompanyFilterSelector.selectedCount,
    aviaCompanyFilterSelector.isActive,
    (value, viewData, count, isActive) => ({
        value,
        viewData,
        count,
        isActive,
    }),
);

export interface IUseAviaCompanyFilter {
    filter: ReturnType<typeof filterSelector>;
    handle: (value: IAviaSearchResultsFilters['company']) => void;
    reset: () => void;
}

export const useAviaCompanyFilter = (): IUseAviaCompanyFilter => {
    const filtering = useAviaFilteringFlow();
    const [filter, handleAsync] = useAsyncAction(filterSelector, filtering.end);
    const handle = useCallback(
        (value: IAviaSearchResultsFilters['company']) => {
            filtering.start(setCompanyFilter(value));
            handleAsync(setCompanyFilter, value);
        },
        [filtering, handleAsync],
    );
    const reset = useCallback(() => {
        filtering.start(resetFilterValue('company'));
        handleAsync(resetFilterValue, 'company');
    }, [handleAsync, filtering]);

    return {filter, handle, reset};
};
