import {createSelector} from 'reselect';
import {useCallback} from 'react';

import {
    resetFilterValue,
    setPartnersFilter,
} from 'reducers/avia/search/results/filters/actions';
import {IAviaSearchResultsFilters} from 'reducers/avia/search/results/filters/reducer';

import {aviaFiltersViewDataSelector} from 'selectors/avia/search/filters/viewData';
import {aviaPartnersFilterSelector} from 'selectors/avia/search/filters/partnersFilter';

import {useAsyncAction} from 'utilities/hooks/useAsyncAction';
import {useAviaFilteringFlow} from 'projects/avia/lib/hooks/useFilteringFlow';

const filterSelector = createSelector(
    aviaPartnersFilterSelector.value,
    aviaFiltersViewDataSelector.partners,
    aviaPartnersFilterSelector.selectedCount,
    aviaPartnersFilterSelector.isActive,
    (value, viewData, count, isActive) => ({
        value,
        viewData,
        count,
        isActive,
    }),
);

export interface IUseAviaPartnersFilter {
    filter: ReturnType<typeof filterSelector>;
    handle: (value: IAviaSearchResultsFilters['partners']) => void;
    reset: () => void;
}

export const useAviaPartnersFilter = (): IUseAviaPartnersFilter => {
    const filtering = useAviaFilteringFlow();
    const [filter, handleAsync] = useAsyncAction(filterSelector, filtering.end);
    const handle = useCallback(
        (value: IAviaSearchResultsFilters['partners']) => {
            filtering.start(setPartnersFilter(value));
            handleAsync(setPartnersFilter, value);
        },
        [filtering, handleAsync],
    );
    const reset = useCallback(() => {
        filtering.start(resetFilterValue('partners'));
        handleAsync(resetFilterValue, 'partners');
    }, [handleAsync, filtering]);

    return {filter, handle, reset};
};
