import {useCallback} from 'react';
import {createSelector} from 'reselect';

import {setPlusPointsFilter} from 'reducers/avia/search/results/filters/actions';

import {aviaFiltersViewDataSelector} from 'selectors/avia/search/filters/viewData';
import {aviaPlusPointsFilterSelector} from 'selectors/avia/search/filters/plusPointsFilter';

import {useAsyncAction} from 'utilities/hooks/useAsyncAction';
import {useAviaFilteringFlow} from 'projects/avia/lib/hooks/useFilteringFlow';

const filterSelector = createSelector(
    aviaPlusPointsFilterSelector.value,
    aviaFiltersViewDataSelector.plusPoints,
    (value, viewData) => ({
        value,
        viewData,
    }),
);

export const useAviaPlusPointsFilter = (): [
    ReturnType<typeof filterSelector>,
    () => void,
] => {
    const filtering = useAviaFilteringFlow();
    const [filter, handleAsync] = useAsyncAction(
        filterSelector,
        filtering.end,
        200,
    );
    const handle = useCallback(() => {
        const enabled = !filter.value.enabled;

        filtering.start(setPlusPointsFilter({enabled}));
        handleAsync(setPlusPointsFilter, enabled);
    }, [filter.value.enabled, handleAsync, filtering]);

    return [filter, handle];
};
