import {useMemo} from 'react';

import {
    IUseAviaTransfersFilter,
    useAviaTransfersFilter,
} from 'projects/avia/lib/hooks/filters/transfers';
import {
    IUseAviaBaggageFilter,
    useAviaBaggageFilter,
} from 'projects/avia/lib/hooks/filters/baggage';
import {
    IUseAviaCompanyFilter,
    useAviaCompanyFilter,
} from 'projects/avia/lib/hooks/filters/company';
import {
    IUseAviaAirportsFilter,
    useAviaAirportsFilter,
} from 'projects/avia/lib/hooks/filters/airports';
import {
    IUseAviaTimeFilter,
    useAviaTimeFilter,
} from 'projects/avia/lib/hooks/filters/time';
import {
    IUseAviaPartnersFilter,
    useAviaPartnersFilter,
} from 'projects/avia/lib/hooks/filters/partners';

import {
    IUseAviaSortingFilter,
    useAviaSortingFilter,
} from 'projects/avia/hooks/useAviaSortingFilter';

export interface IUseAviaTotalFilters {
    activeFiltersCount: number;
    transfersFilter: IUseAviaTransfersFilter;
    baggageFilter: IUseAviaBaggageFilter;
    companyFilter: IUseAviaCompanyFilter;
    airportsFilter: IUseAviaAirportsFilter;
    timeFilter: IUseAviaTimeFilter;
    partnersFilter: IUseAviaPartnersFilter;
    sortingFilter: IUseAviaSortingFilter;
}

export const useAviaTotalFilters = (): IUseAviaTotalFilters => {
    const transfersFilter = useAviaTransfersFilter();
    const baggageFilter = useAviaBaggageFilter();
    const companyFilter = useAviaCompanyFilter();
    const airportsFilter = useAviaAirportsFilter();
    const timeFilter = useAviaTimeFilter();
    const partnersFilter = useAviaPartnersFilter();
    const sortingFilter = useAviaSortingFilter();
    const activeFiltersCount = useMemo(() => {
        return (
            Number(
                transfersFilter.filter.isActive ||
                    airportsFilter.filter.transfersIsActive,
            ) +
            Number(baggageFilter.filter.isActive) +
            Number(companyFilter.filter.isActive) +
            Number(airportsFilter.filter.directionsIsActive) +
            Number(timeFilter.filter.isActive) +
            Number(partnersFilter.filter.isActive)
        );
    }, [
        transfersFilter,
        baggageFilter,
        companyFilter,
        airportsFilter,
        timeFilter,
        partnersFilter,
    ]);

    return {
        transfersFilter,
        baggageFilter,
        companyFilter,
        airportsFilter,
        timeFilter,
        partnersFilter,
        activeFiltersCount,
        sortingFilter,
    };
};
