import {useMemo} from 'react';

import useQuery from 'utilities/hooks/useQuery';

export function useAviaTestContext(): {
    variantTestContext?: string;
    paymentTestContext?: string;
} {
    const {variantTestContext, paymentTestContext} = useQuery([
        'variantTestContext',
        'paymentTestContext',
    ]);

    return useMemo(
        () => ({
            variantTestContext: variantTestContext
                ? variantTestContext
                : undefined,
            paymentTestContext: paymentTestContext
                ? paymentTestContext
                : undefined,
        }),
        [variantTestContext, paymentTestContext],
    );
}
