import {useCallback} from 'react';

import {TAviaBaseFilterAction} from 'reducers/avia/search/results/filters/actions';

import {useAviaUiContext} from 'projects/avia/context/AviaUiContext';
import {useAviaFiltersBufferContext} from 'projects/avia/context/AviaFiltersBufferContext';

export const useAviaFilteringFlow = (): {
    start: (action: TAviaBaseFilterAction) => void;
    end: () => void;
} => {
    const {showOverlay, hideOverlay} = useAviaUiContext();
    const filtersBuffer = useAviaFiltersBufferContext();

    const start = useCallback(
        (action: TAviaBaseFilterAction) => {
            filtersBuffer.put(action);
            showOverlay();
        },
        [filtersBuffer, showOverlay],
    );

    const end = useCallback(() => {
        filtersBuffer.flush();
        hideOverlay();
    }, [filtersBuffer, hideOverlay]);

    return {
        start,
        end,
    };
};
