import {useCallback, useRef} from 'react';
import {useDispatch} from 'react-redux';
import {getType} from 'typesafe-actions';

import {flushAviaFilters} from 'reducers/avia/search/results/filters/thunk';
import {
    resetFilterValue,
    TAviaBaseFilterAction,
} from 'reducers/avia/search/results/filters/actions';

import {EAviaRumEvents} from 'projects/avia/lib/EAviaRumEvents';

import {useRumUi} from 'contexts/RumUiContext';

export function useAviaFiltersBuffer() {
    const rumUi = useRumUi();
    const dispatch = useDispatch();
    const bufferRef = useRef<TAviaBaseFilterAction[]>([]);

    const put = useCallback(
        (action: TAviaBaseFilterAction) => {
            if (action.type === getType(resetFilterValue)) {
                bufferRef.current.push(action);
            } else {
                bufferRef.current = [
                    ...bufferRef.current.filter(
                        ({type}) => type !== action.type,
                    ),
                    action,
                ];
            }
        },
        [bufferRef],
    );
    const flush = useCallback(() => {
        rumUi.measure(EAviaRumEvents.Filter);
        dispatch(flushAviaFilters(bufferRef.current));
        bufferRef.current = [];
    }, [rumUi, dispatch, bufferRef]);

    return {flush, put};
}
