import {INearAnswer} from 'server/services/AviaNearService/types/IAviaNear';
import {IPrepareNearAnswer} from 'projects/avia/components/MapNearAirports/types';

import {replaceQuery} from 'utilities/url';
import {aviaURLs} from 'projects/avia/lib/urls';

import {compareNearAirports} from './comparators/compareNearAirports';

export function prepareNearAnswer(
    nearAnswer: INearAnswer,
    href: string,
): IPrepareNearAnswer {
    return {
        toPoint: nearAnswer.toPoint,
        nearPoints: nearAnswer.nearPoints
            .slice()
            .sort(compareNearAirports)
            .map(nearPoint => ({
                ...nearPoint,
                url: aviaURLs.getSearchResultsUrl(
                    replaceQuery(href, {
                        toName: nearPoint.title,
                        toId: nearPoint.key,
                    }),
                ),
            })),
    };
}
