import {IResultVariantPrice} from 'selectors/avia/utils/denormalization/prices';

import {compareWith} from 'projects/avia/lib/comparators/compareWith';
import {ECompareResult} from 'projects/avia/lib/comparators/TComparator';
import {compareNumbers} from 'projects/avia/lib/comparators/compareNumbers';
import {PriceComparator} from 'utilities/currency/compare';

export const compareResultVariants = (priceComparator: PriceComparator) =>
    compareWith((a: IResultVariantPrice, b: IResultVariantPrice) => {
        const tariffComparison = priceComparator.compare(a.tariff, b.tariff);

        if (tariffComparison === ECompareResult.EQ) {
            if (a.fromCompany) {
                return ECompareResult.LT;
            }

            if (b.fromCompany) {
                return ECompareResult.GT;
            }

            return compareNumbers(a.queryTime, b.queryTime);
        }

        return tariffComparison;
    });
