import {IAviaParams} from 'server/services/AviaSearchService/types/IAviaParams';
import {IAviaDataByPointKey} from 'server/services/AviaGeoService/types/IAviaDataByPointKey';

import {ICoordinate} from 'server/utilities/earthGeometry';

export interface IAviaNearAirportsOwnParams {
    fromId: number;
    toId: number;
    toPhraseFrom: string;
    toCoords: ICoordinate;
}

export interface IAviaNearAirportsParams
    extends Omit<IAviaParams, 'fromId' | 'toId'>,
        IAviaNearAirportsOwnParams {}

export function packNearAirportsParams(
    params: IAviaParams,
    dataByPointKeyFrom: IAviaDataByPointKey | null,
    dataByPointKeyTo: IAviaDataByPointKey | null,
): IAviaNearAirportsParams {
    return {
        ...params,
        fromId: dataByPointKeyFrom?.settlement?.id ?? -1,
        fromName: dataByPointKeyFrom?.settlement?.title ?? '',
        toId: dataByPointKeyTo?.settlement?.id ?? -1,
        toName: dataByPointKeyTo?.settlement?.title ?? '',
        toPhraseFrom: dataByPointKeyTo?.settlement?.phraseFrom ?? '',
        toCoords: {
            latitude: dataByPointKeyTo?.settlement?.latitude ?? 0,
            longitude: dataByPointKeyTo?.settlement?.longitude ?? 0,
        },
    };
}
