const listeners = new Set<PostMessageListener>();

type PostMessageListener = (event: MessageEvent) => any;

function initWindowListener() {
    window.addEventListener('message', handleMessage);
}

function removeWindowListener() {
    window.removeEventListener('message', handleMessage);
}

function unsubscribe(listener: PostMessageListener) {
    listeners.delete(listener);

    if (listeners.size === 0) {
        removeWindowListener();
    }
}

function handleMessage(event: MessageEvent) {
    listeners.forEach(listener => listener(event));
}

function subscribe(listener: PostMessageListener) {
    if (listeners.size === 0) {
        initWindowListener();
    }

    listeners.add(listener);

    return () => unsubscribe(listener);
}

export default {
    subscribe,
};
