import moment from 'moment';

import {IAviaSearchFormValues} from '../components/SearchForm/types';

import {CHAR_EM_DASH} from 'utilities/strings/charCodes';
import humanizePeriod, {humanizeDate} from 'utilities/dateUtils/humanizePeriod';
import {getNow} from 'utilities/dateUtils';

import * as i18nPlural from 'i18n/common-plural';

interface IPreparedPreviousSearchData {
    title: string;
    date: string | null;
    passengers: string;
}

export function preparePreviousSearchData(
    item: IAviaSearchFormValues,
): IPreparedPreviousSearchData {
    const title = `${item.from.inputValue} ${CHAR_EM_DASH} ${item.to.inputValue}`;
    const passengersCount = item.adults + item.children + item.infants;

    return {
        title,
        date: getDateStr(item),
        passengers: i18nPlural.passengers({count: passengersCount}),
    };
}

function getDateStr(item: IAviaSearchFormValues): string | null {
    if (!item.startDate || isOutdated(item)) {
        // протухшие даты не показываем
        return null;
    }

    if (!item.isRoundTrip || !item.endDate) {
        return humanizeDate(item.startDate);
    }

    return humanizePeriod(item.startDate, item.endDate, {
        short: true,
        checkSameDate: false,
        checkAnotherEndYear: false,
    });
}

export function isOutdated(item: IAviaSearchFormValues): boolean {
    return !item.startDate || moment(item.startDate).isBefore(getNow(), 'day');
}
