import {IAviaRedirectPageParams} from 'server/api/AviaTicketDaemonApi/types/IAviaTDRedirect';

import {delay} from 'utilities/async/delay';

import aviaBrowserProvider from 'serviceProvider/avia/aviaBrowserProvider';

const REQUEST_TIMEOUT = 300;
const MAX_VARIANT_TIMEOUT = 2000;
const MAX_TIMEOUT = 20000;

export function findVariant(params: IAviaRedirectPageParams) {
    const retries = Math.floor(MAX_TIMEOUT / REQUEST_TIMEOUT);

    return waitForVariant(params, retries);
}

function waitForVariant(
    params: IAviaRedirectPageParams,
    retries: number,
): Promise<void> {
    return aviaBrowserProvider.checkVariantExistence(params).then(data => {
        if (data.found) {
            return;
        }

        // Если опрос завершился, то ждем еще не более MAX_VARIANT_TIMEOUT пока данные расползутся по хранилищам
        if (data.complete) {
            retries = Math.min(
                retries,
                Math.floor(MAX_VARIANT_TIMEOUT / REQUEST_TIMEOUT),
            );
        }

        if (retries <= 0) {
            throw new Error('variant not found');
        }

        retries--;

        return delay(REQUEST_TIMEOUT)
            .then(() => {
                waitForVariant(params, retries);
            })
            .catch(() => {
                waitForVariant(params, retries);
            });
    });
}
