import {uniqBy} from 'lodash';

import {IResultCompany} from 'selectors/avia/utils/denormalization/company';
import {IResultAviaFlight} from 'selectors/avia/utils/denormalization/flight';
import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

export function getSegmentAviaCompanies(
    segments: IResultAviaFlight[],
): IResultCompany[] {
    return uniqBy(
        segments.map(flight => flight.operating?.company || flight.company),
        company => company.id,
    );
}

export function getVariantAviaCompanies(
    variant: IResultAviaVariant,
): IResultCompany[] {
    const {
        route: [forward, backward],
    } = variant;

    return getSegmentAviaCompanies([...forward, ...backward]);
}

export function isSameCompanyForVariant(variant: IResultAviaVariant): boolean {
    return getVariantAviaCompanies(variant).length === 1;
}
