import {AVIA_PARAMS_KEYS} from 'projects/avia/constants/queryParams';

import {IAviaParams} from 'server/services/AviaSearchService/types/IAviaParams';
import TUniqueString from 'types/TUniqueString';

export type TAviaSearchFormParamsKey =
    TUniqueString<'TAviaSearchFormParamsKey'>;

export function getAviaSearchParamsKey(
    query: IAviaParams,
): TAviaSearchFormParamsKey {
    return AVIA_PARAMS_KEYS.map(key => query[key] || '').join(
        ';',
    ) as TAviaSearchFormParamsKey;
}

export function isSameAviaSearchParamsKeys(
    left: TAviaSearchFormParamsKey,
    right: TAviaSearchFormParamsKey,
) {
    return left === right;
}
