import {IAviaVariantGroup} from 'selectors/avia/utils/denormalization/variantGroup';

import {compareWith} from 'projects/avia/lib/comparators/compareWith';
import {PriceComparator} from 'utilities/currency/compare';

export const compareVariantsByPrice = (priceComparator: PriceComparator) =>
    compareWith((groupA: IAviaVariantGroup, groupB: IAviaVariantGroup) => {
        const minPriceA = groupA.cheapestVariantsByTariff.cheapest.price;
        const minPriceB = groupB.cheapestVariantsByTariff.cheapest.price;
        return priceComparator.compare(minPriceA.tariff, minPriceB.tariff);
    });
